﻿using AZVIC.Ei8htPOS.BAL;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.POSRetail.Helpers;
using AZVIC.Ei8htPOS.Utilities;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Controls.Primitives;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;

namespace AZVIC.Ei8htPOS.POSRetail.Controls
{
    /// <summary>
    /// Interaction logic for HappyHourSelection.xaml
    /// </summary>
    public partial class TaxSelection : Page
    {
        static List<Tax> _Taxes;
        public TaxSelection()
        {
            InitializeComponent();
            LoadTax();
        }
        private void LoadTax()
        {
            _Taxes = TaxBL.GetList(Guid.Empty,string.Empty);
            gvTaxSelection.ItemsSource = _Taxes;
        }

        private void btnSaveTax_Click(object sender, RoutedEventArgs e)
        {
            if (Validate())
            {
                Tax _tax = new Tax();
                _tax.TaxName = txTaxName.Text.Trim();
                _tax.TaxDescription = string.Empty;
                _tax.TaxType = (ddlTaxType.SelectedItem as ComboBoxItem).Content.ToString().ToLower();
                _tax.TaxValue = decimal.Parse(txtValue.Text.Trim());
                _tax.ApplyTaxAsDefault = chkIsDefault.IsChecked != null ? true : false ;
                if (TaxBL.Save(_tax))
                {
                    LoadTax();
                    MessageBox.Show("Tax Saved successfully");
                }
            }
            
        }

        private void btnRemoveTax_Click(object sender, RoutedEventArgs e)
        {
            if (gvTaxSelection.SelectedItem != null)
            {
                Tax selectedItem = (Tax)gvTaxSelection.SelectedItem;
                if (TaxBL.Delete(selectedItem.TaxID))
                {
                    LoadTax();
                    MessageBox.Show("Tax removed successfully");
                }
            }
        }

        private void btnCancel_Click(object sender, RoutedEventArgs e)
        {
           
        }

        private bool Validate()
        {
            if (string.IsNullOrEmpty(txTaxName.Text))
            {
                MessageBox.Show("Please enter a valid Tax name");
                return false;
            }
            if (string.IsNullOrEmpty(txtValue.Text))
            {
                MessageBox.Show("Please enter a valid Tax Value");
                return false;
            }
            else
            {
                if (!ValidationUtility.ValidateDecimal(txtValue.Text))
                {
                    MessageBox.Show("Please enter a valid Tax Value");
                }
            }
            return true;
        }
    }
}
